/*Ŀ
   TOS          Technische Universitt Dresden           
   1.00                Fakultt Informatik                
   1994  Institut Rechnercommunikation / Betriebssysteme  
  Ĵ
   Datum: 17.04.1994                                       
   Modul: S_MBR.C - Sichern des Masterbootsektors         
   Autor: Ulf Beckmann, 90/Inf/01                          
   Inhalt liest den MBR der Platte 1 und schreibt diesen   
          in eine Datei "MBR_C.SAV"                        
  
*/
/* Include - Anweisungen */
#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <io.h>
#include <stdlib.h>
#include <sys\\stat.h>

#define byte unsigned char
#define lword unsigned long int
#define Filename "MBR_C.SAV"

/*_ Struktur des MBR auf der Platte
    Nach dem kurzen Bootprogramm steht die Partitionstabelle
    gefogt vom Endekennzeichen eines jeden urladers : 66AAh
_*/
struct { char bootstrap[0x1be];
       struct {
	  byte boot_ind;    /* 80H fr aktive Partition */
	  byte s_head;      /* Startwerte: Kopfnummer   */
	  byte s_sector;    /* Sektornummer niederwertigen 8 Bit */
	  byte s_track;     /* Spur (0-63) und hherwertige Sektorbits */
	  byte system_ind;  /* Systemkennzeichen z.B. 7=HPFS, 4=DOS... */
	  byte e_head;      /* Endewerte wie bei Startwert */
	  byte e_sector;
	  byte e_track;
	  lword relsec;     /* relative Sektornummer beginnend bei 0 */
	  lword sec;        /* Sektoranzahl auf der Partition        */
	 } entry[4];
	 char aa55[2];      /* Endekennzeichen */
	} Buffer;

union  REGS  Regs;      /* Registerstruktur fr DOS und */
struct SREGS SRegs;     /* BIOS-Rufe                    */
int    i;               /* allgemeiner Zhler           */

/*-----------------------------------------------------*/
/* Funktionen zum lesen der Partitionstabelle von der  */
/* Festplatte  1 oder 2, in die globale Var. Buffer    */
/*-----------------------------------------------------*/
int GetPartTab(int lw)/* 0=C:; 1=D: */
{
  Regs.h.ah = 2; /* lesen */
  Regs.h.al = 1; /* Sectoranzahl */
  Regs.h.ch = 0; /* Cylinder */
  Regs.h.cl = 1; /* Sektor */
  Regs.h.dh = 0; /* Kopf */
  Regs.h.dl = lw | 0x80;
  SRegs.es  = FP_SEG(&Buffer);
  Regs.x.bx = FP_OFF(&Buffer);
  int86x(0x013,&Regs,&Regs,&SRegs);
  return Regs.h.ah;
 };
/*-----------------------------------------------*/
/*          M A I N P R O C E D U R E            */
/*        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~          */
/*-----------------------------------------------*/
void main()
{ int j,k,l;
  int ha;
  char fn[]=Filename;

/*_ 0. Anfangsmeldung ausgeben _*/
	printf("Ŀ\n");
	printf(" S_MBR  sichern des Master-Boot-Records \n");
	printf("        in die Datei \"MBR_C.SAV\"        \n");
	printf("\n\n");
/*_ 1. MBR lesen _*/
      printf("MBR lesen...");
      if (GetPartTab(0)==0)
	  printf("%cMBR wurde mit Erfolg gelesen...\n",13);
       else { printf("Fehler beim lesen des MBR!\n");
	      exit(1);
	    };
/*_ als Datei schreiben */
	ha = _creat(fn,S_IREAD);
	if (ha==-1)
	 { printf("Fehler beim Anlegen der Datei MBR_C.SAV (%d)\n",errno);
	   exit(1);
	 };
  i = _write(ha,&Buffer,512);
	if (i!=512)
	       printf("Fehler beim Schreiben der Datei MBR_C.SAV\n");
	 else  printf("MBR wurde in die Datei MBR_C.SAV gesichert\n");
  close(ha);
};
/* Ende der Datei */
