/*Ŀ
   TOS          Technische Universitt Dresden           
   1.00                Fakultt Informatik                
   1994  Institut Rechnercommunikation / Betriebssysteme  
  Ĵ
   Datum: 17.04.1994                                       
   Modul: W_MBR.C - Schreiben des Masterbootsektors        
   Autor: Ulf Beckmann, 90/Inf/01                          
   Inhalt liest den MBR aus der Datei "MBR_C.SAV" und      
          schreibt diesen auf die Platte 1                 
  
*/
/* Include Anweisungen */
#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <io.h>
#include <stdlib.h>
#include <fcntl.h>

#define byte unsigned char
#define lword unsigned long int
#define Filename "MBR_C.SAV"

/*_ Struktur des MBR auf der Platte
    Nach dem kurzen Bootprogramm steht die Partitionstabelle
    gefolgt vom Endekennzeichen eines jeden urladers : 66AAh
_*/
struct { char bootstrap[0x1be];
       struct {
	  byte boot_ind;    /* 80H fr aktive Partition */
	  byte s_head;      /* Startwerte: Kopfnummer   */
	  byte s_sector;    /* Sektornummer niederwertigen 8 Bit */
	  byte s_track;     /* Spur (0-63) und hherwertige Sektorbits */
	  byte system_ind;  /* Systemkennzeichen z.B. 7=HPFS, 4=DOS... */
	  byte e_head;      /* Endewerte wie bei Startwert */
	  byte e_sector;
	  byte e_track;
	  lword relsec;     /* relative Sektornummer beginnend bei 0 */
	  lword sec;        /* Sektoranzahl auf der Partition        */
	 } entry[4];
	 char aa55[2];      /* Endekennzeichen */
	} Buffer;

union  REGS  Regs;      /* Registerstruktur fr DOS und */
struct SREGS SRegs;     /* BIOS-Rufe                    */
int    i;               /* allgemeiner Zhler           */

/*---------------------------------------------------------*/
/* Funktionen zum schreiben der Partitionstabelle von der  */
/* Festplatte  1 oder 2, aus der globale Var. Buffer       */
/*---------------------------------------------------------*/
int PutPartTab(int lw)/* 0=C:; 1=D: */
{ Regs.h.ah = 3; /* schreiben */
  Regs.h.al = 1; /* Sectoranzahl */
  Regs.h.ch = 0; /* Cylinder */
  Regs.h.cl = 1; /* Sektor */
  Regs.h.dh = 0; /* Kopf */
  Regs.h.dl = lw | 0x80;
  SRegs.es  = FP_SEG(&Buffer);
  Regs.x.bx = FP_OFF(&Buffer);
  int86x(0x013,&Regs,&Regs,&SRegs);
  return Regs.h.ah;
 };
/*-----------------------------------------------*/
/*          M A I N P R O C E D U R E            */
/*        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~          */
/*-----------------------------------------------*/
void main()
{ int j,k,l;
  int ha;
  char fn[]=Filename;
/*_ 0. Anfangsmeldung ausgeben */
	printf("Ŀ\n");
	printf(" W_MBR  schreiben des Master-Boot-Records \n");
	printf("        aus  \"MBR_C.SAV\" auf Platte 1      \n");
	printf("\n\n");
/* 1. Datei lesen */
 ha = open(fn,O_RDONLY);
 if (ha==-1)
  { printf("Ich kann die Datei MBR_C.SAV micht ffnen!\n");
    exit(1);
  };
  i = _read(ha,&Buffer,512);
  close(ha);
 if (i!=512)
  { printf("Fehler beim lesen von MBR_C.SAV!\n");
    exit(1);
  };
  if (PutPartTab(0)==0)
	printf("MBR wurde mit Erfolg auf die Platte geschrieben\n");
   else printf("Fehler beim Schreiben des MBR\n");
 };
/* Ende der Datei */
