/* Include - Anweisungen */
#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <io.h>
#include <stdlib.h>

#define byte unsigned char
#define lword unsigned long int


/*_ Struktur des MBR auf der Platte
    Nach dem kurzen Bootprogramm steht die Partitionstabelle
    gefogt vom Endekennzeichen eines jeden urladers : 66AAh
_*/
struct { char bootstrap[0x1be];
       struct {
	  byte boot_ind;    /* 80H fr aktive Partition */
	  byte s_head;      /* Startwerte: Kopfnummer   */
	  byte s_sector;    /* Sektornummer niederwertigen 8 Bit */
	  byte s_track;     /* Spur (0-63) und hherwertige Sektorbits */
	  byte system_ind;  /* Systemkennzeichen z.B. 7=HPFS, 4=DOS... */
	  byte e_head;      /* Endewerte wie bei Startwert */
	  byte e_sector;
	  byte e_track;
	  lword relsec;     /* relative Sektornummer beginnend bei 0 */
	  lword sec;        /* Sektoranzahl auf der Partition        */
	 } entry[4];
	 char aa55[2];      /* Endekennzeichen */
	} Buffer;

union  REGS  Regs;      /* Registerstruktur fr DOS und */
struct SREGS SRegs;     /* BIOS-Rufe                    */
int    i;               /* allgemeiner Zhler           */

/*-----------------------------------------------------*/
/* Funktionen zum lesen der Partitionstabelle von der  */
/* Festplatte  1 oder 2, in die globale Var. Buffer    */
/*-----------------------------------------------------*/
int GetPartTab(int lw)/* 0=C:; 1=D: */
{
  Regs.h.ah = 2; /* lesen */
  Regs.h.al = 1; /* Sectoranzahl */
  Regs.h.ch = 0; /* Cylinder */
  Regs.h.cl = 1; /* Sektor */
  Regs.h.dh = 0; /* Kopf */
  Regs.h.dl = lw | 0x80;
  SRegs.es  = FP_SEG(&Buffer);
  Regs.x.bx = FP_OFF(&Buffer);
  int86x(0x013,&Regs,&Regs,&SRegs);
  return Regs.h.ah;
 };
/*-----------------------------------------------------*/
/* Funktionen zum schreiben der Partitionstabelle von  */
/* Festplatte  1 oder 2, in die globale Var. Buffer    */
/*-----------------------------------------------------*/
int PutPartTab(int lw)/* 0=C:; 1=D: */
{
  Regs.h.ah = 3; /* schreiben */
  Regs.h.al = 1; /* Sectoranzahl */
  Regs.h.ch = 0; /* Cylinder */
  Regs.h.cl = 1; /* Sektor */
  Regs.h.dh = 0; /* Kopf */
  Regs.h.dl = lw | 0x80;
  SRegs.es  = FP_SEG(&Buffer);
  Regs.x.bx = FP_OFF(&Buffer);
  int86x(0x013,&Regs,&Regs,&SRegs);
  return Regs.h.ah;
 };
/*-----------------------------------------------*/
/*          M A I N P R O C E D U R E            */
/*        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~          */
/*-----------------------------------------------*/
void main()
{ int j,k,l;
  int ha;

/*_ 0. Anfangsmeldung ausgeben _*/
	printf("\tĿ\n");
	printf("\t R_DosMbr setzt die DOS und OS/2 Partitionen  \n");
	printf("\t         in den inaktiven Zustand. Aufruf nur\n");
	printf("\t       in Verbindung mit dem Bootmanager   \n");
	printf("\t         und einigen Grundkenntnissen empfohĳ\n");
	printf("\t         len. Sonst kann's schief gehen!!    \n");
	printf("\t\n\n");
	printf("\n\tSoll ich wirklich weitermachen? (j/n):");
	j=getch();
	if (j=='J') j='j';
	if (j!='j')
	{ printf(" N\n\n\tABBRUCH\n");
	  exit(1);
	};
/*_ 1. MBR lesen _*/
      printf("J\n\nMBR lesen...");
      if (GetPartTab(0)==0)
	  printf("%cMBR wurde mit Erfolg gelesen...\n",13);
       else { printf("Fehler beim lesen des MBR!\n");
	      exit(1);
	    };
  for (i=0;i<4;i++)
  {
   if (Buffer.entry[i].system_ind==1)
   { Buffer.entry[i].system_ind=0x11;
      printf("gefunden und gendert: DOS 12-bit FAT\n");
   };
   if (Buffer.entry[i].system_ind==4)
   { Buffer.entry[i].system_ind=0x14;
      printf("gefunden und gendert: DOS 16-bit FAT < 32M\n");
   };
   if (Buffer.entry[i].system_ind==6)
   { Buffer.entry[i].system_ind=0x16;
      printf("gefunden und gendert: DOS 16-bit FAT >32M\n");
   };
   if (Buffer.entry[i].system_ind==7)
   { Buffer.entry[i].system_ind=0x17;
      printf("gefunden und gendert: OS/2 HPFS\n");
   };
  };
      if (PutPartTab(0)==0)
	  printf("MBR wurde mit Erfolg geschrieben...\n");
       else { printf("Fehler beim schreiben des MBR!\n");
	      exit(1);
	    };
};
/* Ende der Datei */
