#include <stdio.h>
#include <conio.h>
#include <direct.h>
#include <dos.h>
#include <string.h>
#include <time.h>
#include <stdlib.h>

#include "login.h"

struct usr	*getusr();
char	*getfld();
char		*motd, *passwd, *logfile;	   /* for default overrides */
int 		root = ROOT;

#define ADD 	'a'
#define CHANGE	'c'
#define DELETE	'd'
#define LIST	'l'

void
main(argc, argv)
int 	argc;
char	**argv;
{
	struct	usr 	*usr;
	extern	char *optarg;
	extern	int optind;
	int 	type = '0', errflg = 0, c;

	/* l=list a=add d=delete c=change */
	while ((c = getopt(argc, argv, "acdl")) != EOF) {
		switch (tolower(c)) {
		case ADD:
		case CHANGE:
		case DELETE:
		case LIST:
			type = c;
			break;
        default:                /* error */
			errflg++;
			break;
		}
	}

    if (errflg) {
		fprintf(stderr, USAGE);
		exit(9);
	}

	/* override the PASSWD file path */
	if ((passwd = getenv("PASSWD")) == NULL)
		passwd = PASSWD;

	/* override the LOGFILE file path */
	if ((logfile = getenv("LOGFILE")) == NULL)
		logfile = LOGFILE;

	/* override the MOTD file path */
	if ((motd = getenv("MOTD")) == NULL)
		motd = MOTD;

    /* override the ROOT user id */
	if (getenv("ROOT"))
		root = atoi(getenv("ROOT"));

	switch (type) {
	case ADD:
		adduser();
		break;
#ifdef FINISHED
    case CHANGE:
		chguser();
		break;
    case DELETE:
		deluser();
		break;
    case LIST:
		lstuser();
		break;
#endif
    }
}

/*#  name:id number:drive:home directory:command or "shell"  #*/
adduser()
{
	struct	usr u;
	char	linbuf[256];
	int 	run = 1;
	unsigned drive;

	while (run) {
		while (1) {
			fprintf(stderr, "User Name or (q)uit: ");
			memset(linbuf, '\0', sizeof (linbuf));
			u.name[0] = '\0';
			gets(linbuf);
			if (toupper(linbuf[0]) == 'Q' && strlen(linbuf) == 1) {
				run = 0;
				break;
            }
			if (strlen(linbuf) > 15) {
				fprintf(stderr, "user name must be less than 15 characters\n");
				continue;
			} else {
				strcpy(u.name, linbuf);
				break;
			}
			if (*u.name && getusr(passwd, u.name))
				fprintf(stderr, "user %s already assigned\n", u.name);
			else
				break;
		}
		if (!run)
			break;

        while (1) {
			fprintf(stderr, "User ID Number (0-999) or (q)uit: ");
			memset(linbuf, '\0', sizeof (linbuf));
			gets(linbuf);
			if (toupper(linbuf[0]) == 'Q') {
				run = 0;
				break;
            }
			u.uid = atoi(linbuf);
			if (u.uid > 999 || u.uid < 0) {
				fprintf(stderr, "user ID must be 0-999\n");
				continue;
			}

            if (chkuid(passwd, u.uid))
				fprintf(stderr, "user ID %d already assigned\n", u.uid);
            else
				break;
		}
		if (!run)
			break;

		_dos_getdrive(&drive);				  /* use current drive as default */

		do {
			fprintf(stderr, "Enter Drive (A-Z) or (0) to quit (default is \'%c\'): ", drive+'@');
			gets(linbuf);
			if (linbuf[0] == '0') {
                run = 0;
				break;
			} else if (!strlen(linbuf))
				linbuf[0] = drive + '@';
        } while ((linbuf[0] = toupper(linbuf[0])) < 'A' || linbuf[0] > 'Z');

        if (!run)
			break;

        u.drive = linbuf[0] - '@';


		fprintf(stderr, "Enter User password: ");
		gets(linbuf);
		if (strlen(linbuf))
			strcpy(u.passwd, linbuf);
		else
			memset(u.passwd, '\0', sizeof (u.passwd));

		fprintf(stderr, "Enter HOME directory: ");
		gets(linbuf);
		if (!strlen(linbuf)) {						/* no HOME specified */
			if (getcwd(u.home, 80) == NULL) 		/* current directory */
				error(4);
		} else
			strcpy(u.home, linbuf);

		fprintf(stderr, "Enter COMMAND or \"shell\" (shell is default): ");
		gets(linbuf);
		strcpy(u.shell, *linbuf ? linbuf : "shell");
		if (ask(&u))
			if (install(&u))
				fprintf(stderr, "install failed\n");
    }
}

/* write entry to password file */
int
install(struct usr *u)
{
	FILE	*fp;
	char	*p;

	/* open password file */
	if ((fp = fopen(passwd, "a+")) == NULL) {
		error(3);
		return (1);
	}
	p = encrypt(u->passwd);
    fprintf(fp, "%s:%d:%s:%c:%s:%s\n", u->name, u->uid,
		*u->passwd ? p : "", u->drive+'@',
		u->home, u->shell);

	if (p)
		free(p);

    fclose(fp);
	return (0);
}


/* display user info & ask for verification */
ask(struct usr * u)
{
	char	linbuf[256];
	fprintf(stderr, "\n");
	fprintf(stderr, "name.......%s\n", u->name);        /* 0 */
	fprintf(stderr, "user id....%d\n", u->uid);         /* 1 */
	fprintf(stderr, "password...%s\n", u->passwd);      /* 2 */
	fprintf(stderr, "drive......%c\n", u->drive + '@'); /* 3 */
	fprintf(stderr, "home.......%s\n", u->home);        /* 4 */
	fprintf(stderr, "shell......%s\n", u->shell);       /* 5 */
	while (1) {
		fprintf(stderr, "Is This OK (Y/N)? ");
		gets(linbuf);
		switch (linbuf[0]) {
		case 'Y':
		case 'y':
			return(1);
        case 'N':
		case 'n':
			return(0);
		}
	}
}

int
chkuid(char *passwd, int u)
{
	FILE	*fp;
	int 	found = 0, uuid;
	char	linbuf[256];

	/* open password file */
	if ((fp = fopen(passwd, "r")) == NULL)
		return (0);

	/* read lines from the PASSWD file */
	while (!found && fgets(linbuf, 256, fp)) {
        if (*linbuf == '#')                         /* '#' denotes comment */
			continue;

		uuid = atoi(getfld(linbuf, 1, ':'));       /* user ID */
        found = (uuid == u);
	}
	return (found);
}

struct usr *
getusr(char *l, char *name)
{
	FILE	*fp;
	static	struct usr u;
	char	linbuf[256];
	char	*comspec, *p, shell[80];
	int 	found = 0;

	/* open password file */
	if ((fp = fopen(passwd, "r")) == NULL) {
		error(3);
		return ((struct usr *)NULL);
	}

	/* read lines from the PASSWD file */
	while (!found && fgets(linbuf, 256, fp)) {
		memset(&u, '\0', sizeof (struct usr));      /* clean up structure */

        if (*linbuf == '#')                         /* '#' denotes comment */
			continue;

		if ((p = strchr(linbuf, '\n')) != NULL)     /* zap new-lines */
			*p = '\0';

        strcpy(u.name,   getfld(linbuf, 0, ':'));   /* user name */
		if (!strcmp(u.name, name))					   /* name matches */
			found = 1;
		else
			continue;

        u.uid =     atoi(getfld(linbuf, 1, ':'));   /* user ID */
		strcpy(u.passwd, getfld(linbuf, 2, ':'));   /* user password */

		p = getfld(linbuf, 3, ':');                 /* disk drive */
		u.drive = *p == '\0' ? 0 : *p - '@';        /* set to 0 if none */
        strcpy(u.home,   getfld(linbuf, 4, ':'));   /* home directory */
		strcpy(shell,	 getfld(linbuf, 5, ':'));   /* command/shell */

		if (*u.home == '\0')                        /* no HOME specified */
			if (getcwd(u.home, 80) == NULL) 		/* current directory */
				error(4);

    }

	/* if name was found */
	if (found) {
		if (u.drive == 0)							/* no drive specified */
			_dos_getdrive(&u.drive);				/* use current drive */

		if ((comspec = (char *) getenv("COMSPEC")) == NULL) {
			comspec = "X:\command.com";
			*comspec = (char )u.drive + '@';    /* use current drive */
		}
		/* if "shell" specified, use COMSPEC to find "command.com" */
		if (!strncmp(strupr(shell), "SHELL", 5))
			strcpy(u.shell, comspec);
		else if (p = strchr(shell, '.'))
			if (!strcmp(strupr(p), ".BAT"))     /* execute batch file */
				sprintf(u.shell, "%s /C %s", comspec, shell);
			else
				strcpy(u.shell, shell); 		/* execute whatever */
	} else
		found = 0;
    fclose(fp);
	return (found ? &u : (struct usr *) NULL);
}

