
#include <ctype.h>
#include <stdlib.h>
#include <dos.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>

/* LANOS defined device types (for use() function)  */
#define PRINTER  3
#define DRIVE    4

static union REGS rg;
struct SREGS sg;

char far *error, far *eptr;
char err[120], *bptr;

char buf[81];
char garb[80];

FILE *fp;


main()
{
char user[17];
char pswrd[17];
char filename[23];
char bool;
int pos, pos1, ch, n;

   /*  Print logo, get user name and password  */
   printf("          --- AutoLogin 1.1 for LANtastic (tm) ---");
   printf("\n                    by J Gerring\n");
   printf("\nEnter username: ");
   scanf("%s",user);

   /* get password (a little more complicated that you might think!)  */
   printf("password: ");
   pos = 0;
   ch = getch();
   while (1) {
      if (ch == 13)
	 break;
      if (isgraph(ch)) {
	putchar('*');
	pswrd[pos++] = ch;
	}
      else if (ch == '\b' && pos != 0) {
	pswrd[--pos] = '\0';
	printf("\b \b");
	}
      ch = getch();
      }
   pswrd[pos] = '\0';
   towupper(user);

   /* set up filename, open the user's file */
   strcpy(filename,"\\LANTASTI\\");
   if ((pos = strlen(user)) >= 9) {       /* if username is > 9  use first 4   */
      strncat(filename, user, 4);         /* characters and last 4 characters  */
      strncat(filename, (user+pos-4), 4);
      }
   else
      strcat(filename, user);
   strcat(filename, ".DAT");
   if ((fp = fopen(filename, "r")) == NULL) {
      printf("\n\n\aERROR: Cannot open file - %s... Exiting Login\n\n", filename);
      exit(1);
      }

   /* read file, take indicated action. */
   printf("\nLogging in to all defined servers for your username...\n");
   bool = 0;
   for(;;) {
      /* read line of input from user's file */
      if (!fill_buf()) {
	 if (!bool)
	    printf("\n\aWarning: no data found in file %s\n",filename);
	 printf("\nLogin finished!\n\n");
	 fclose(fp);
	 exit(0);
	 }
	 bool = 1;
	 switch (*buf) {
		case 'L' : login(user,pswrd);
				   break;
		case 'U' : use();
				   break;
		case ';' : break;        /* ignore comment lines */

		default  : printf("\n\aError: invalid command statment ->%s<-\n",buf);
				   break;
		}
	 }
}


login(user,pswrd)
char *user, *pswrd;
{
char login[52];
char server[17];
int pos, pos1, ch, i, ad_no;

   ad_no=4;         /* initialize adapter number */

   /* log into server name found in current line of user's data file */
   if (sscanf(buf, "LOGIN %s%s", server, garb) != 1)
	  if ((i =sscanf(buf, "LOGIN %s%d", server, &ad_no)) != 2) {
		 printf("\n\aWarning: Badly formatted LOGIN statement ->%s<-", buf);
		 return(1);
		 }

   /* check for valid adapter number.  4 indicates none specified */
   if (ad_no < 0 || ad_no > 4) {
	  printf("\n\aWarning: Invalid adapter number specified ->%s<-",buf);
	  return(1);
	  }

   /* set up login string and do interrupt  */
   strcpy(login,"\\\\");
   strcat(login,server);
   strcat(login,"\\");
   strcat(login,user);
   pos=strlen(login);
   login[pos]='*';
   login[pos+1]='\0';
   strcat(login,pswrd);
   pos1=strlen(login);
   login[pos]=0;
   login[pos1+1]=0;

   /* ad_no == 4 => no ad. no. specified, try login on all possible adapters */
   if (ad_no == 4)
	  for (i=0; i <= 3; i++) {
		 rg.x.ax=0x5f81;
		 rg.x.di=(unsigned int)login;
		 rg.h.bl=i;
		 segread(&sg);
		 sg.es=sg.ds;
		 intdosx(&rg,&rg,&sg);
		 if (rg.x.cflag && rg.x.ax == 0x35)    /* break if error is other than  */
			;                                  /*  "Cannot locate network name" */
		 else
			break;
		 }
   else {
	  rg.x.ax=0x5f81;
	  rg.x.di=(unsigned int)login;
	  rg.h.bl=ad_no;
	  segread(&sg);
	  sg.es=sg.ds;
	  intdosx(&rg,&rg,&sg);
	  }

	  if (!rg.x.cflag)
		 printf("\nLogged into: %-s",server);
	  else {
		 get_err();
		 printf("\nError logging into %-s -> %s",server,err);
		 }
}


use()
{
char locname[17], netname[129];
int type;

   /* get local device to redirect and network device name */
   if (sscanf(buf, "USE %s%s%s", locname, netname, garb) != 2) {
      printf("\n\aWarning: Badly fomatted USE statement ->%s<-", buf);
      return(1);
      }

   /* decide type of use, set up registers, do interrupt */
   if (strncmp(locname, "PRN", 3) == 0 || strncmp(locname, "LPT", 3) == 0)
      type = PRINTER;
   else
      type = DRIVE;

   rg.x.ax=0x5f03;
   rg.h.bl=type;
   rg.x.cx=0;
   rg.x.si=(unsigned int)locname;
   rg.x.di=(unsigned int)netname;
   segread(&sg);
   sg.es=sg.ds;
   intdosx(&rg,&rg,&sg);

   /* if carry flag set == error, give message  */
   if (!rg.x.cflag)
      printf("\nDevice %-s redirected to %-s ",locname, netname);
   else {
      get_err();
      printf("\nError redirecting %-s -> %s",locname,err);
      }

}


/* get_err() - Expand LANOS error code to string */
get_err()
{
   /* set up the registers */
   rg.x.bx = rg.x.ax;
   rg.h.al = (unsigned char)rg.x.ax;
   rg.h.ah = 5;                         /* 5 = LANOS funct # to expand error number */
   segread(&sg);
   sg.es=sg.ds;
   int86x(0x2f,&rg,&rg,&sg);

   /* ES:DI now points to a read only string containing expanded error message */
   FP_SEG(error) = sg.es;
   FP_OFF(error) = rg.x.di;
   eptr = error;
   bptr = err;
   do {                 /* read system string to local buffer */
      *bptr = *eptr;
      ++bptr;
      ++eptr;
      } while (*eptr != '\0');
   *bptr = '\0';
}


/* convert entire word to uppercase  */
towupper(wrd)
char *wrd;
{
   do {
   *wrd = toupper(*wrd);
   ++wrd;
      } while (*wrd != '\0');

}


/* fill_buf - read a line from user's data file into global BUF
      returns: 0 - if EOF encountered
	       1 - if buffer was filled                          */
int fill_buf()
{
   int ch, pos;

   /* initialize buffer */
   for (pos = 0; pos <= sizeof(buf); pos++)
      buf[pos] = '\0';

   /* skip white space */
   do {
      ch = fgetc(fp);
      } while (isspace(ch));
   if (ch == EOF)
	 return 0;

   pos = 0;
   while (ch != '\n') {
      buf[pos++] = ch;
      ch = fgetc(fp);
      }
   towupper(buf);
   return 1;
}


