/***************************************************************************
*  AutoLogin: a quick and easy login program for LANtastic(R) NOS (LANOS)
*	      Copyright 1990, 1993 J. A. Gerring
*			Version 2.1
*
*   This source may not be modified, included in another program,
*   distrubuted with another program, or distributed without its
*   documentation and executable without express written permission
*   of the author.
*
*   LANtastic is a Registered Trademark of Artisoft, Inc.
*
*   I may be contacted via the following methods:
*
*   CompuServe ID:  73650,471  (best method)
*   US MAIL:	    5500 N. Valley View #108, Tucson, AZ 85718
*
****************************************************************************/


/* includes */
#include <ctype.h>
#include <stdlib.h>
#include <dos.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <time.h>

/* LANOS defined device types and misc. other defines */
#define PRINTER 	3
#define DRIVE		4
#define MAX_ADAPTERS	6
#define ESC_CHAR	'\x1b'
#define PAUSE_LENGTH	5

/* register declartions */
static union REGS rg;
struct SREGS sg;

/* Misc. buffers and pointers to buffers */
char far *error, far *eptr;
char err[120], *bptr;
char server[17];
char buf[81], garb[80], WaitFlag;

/* file pointer for the AutoLogin data file */
FILE *fp;


/***************************************************************************
* main()
*
*   Entry point for AutoLogin.	Gets user name and password from user and
*   opens the user's data file.
*
*   Calls: login(), waitfor(), use(), auto().
*
****************************************************************************/

main()
{
char user[17];		/* user name	    */
char pswrd[17]; 	/* password	    */
char filename[23];	/* data file name   */
char bool;		/* flag to signal that data has been read from file */
int pos, pos1, ch, n;	/* various variables */


   /*  Print logo */
   printf("            --- AutoLogin 2.1 for LANtastic(R) ---");
   printf("\n                 (c)1990,1993 by J Gerring\n");

   /* check to make sure LANtastic redirector is running */
   if (CheckForLAN() == 0) {
      printf("\n\n\aLANtastic NOS not currently running. Exiting AutoLogin.\n\n");
      exit(2);
      }

   WaitFlag=0;		/* clear WaitFlag => we're not in global wait mode */

   /* get user name from console */
   memset(user, '\0', 17);
   printf("\nEnter username: ");
   scanf("%s",user);
   towupper(user);

   /* get password (a little more complicated that you might think!)  */
   memset(pswrd, '\0', 17);
   printf("password: ");		    /* give user a prompt */
   pos = 0;
   ch = getch();		  /* this loop reads the password getting   */
   while (1) {			  /* characters until enter is hit. It also */
      if (ch == 13)		  /* allows the user to backspace and retype*/
	 break; 		  /* if they make a mistake.		    */
      if (isgraph(ch)) {
	putchar('*');		  /* echo stars for valid input 	    */
	pswrd[pos++] = ch;
	}
      else if (ch == '\b' && pos != 0) {    /* the backspace function	    */
	pswrd[--pos] = '\0';
	printf("\b \b");
	}
      ch = getch();
      }
   pswrd[pos] = '\0';		  /* null terminate the password	    */
   towupper(pswrd);		  /* convert it to upper case		    */

   /* set up filename, open the user's file */
   strcpy(filename,"\\LANTASTI\\");
   if ((pos = strlen(user)) >= 9) {       /* if username is > 9  use first 4   */
      strncat(filename, user, 4);         /* characters and last 4 characters  */
      strncat(filename, (user+pos-4), 4);
      }
   else
      strcat(filename, user);
   strcat(filename, ".DAT");
   if ((fp = fopen(filename, "r")) == NULL) {
      printf("\n\n\aERROR: Cannot open file - %s... Exiting Login\n\n", filename);
      exit(1);
      }

   /* Turn off LANtastic's Autologin feature.  This will make logins and uses faster. */
   /* fake up input buffer for the autolog() function to parse */
   memset(buf, '\0', 81);
   strcat(buf, "AUTO OFF");
   autolog(user,pswrd);	      /* call autolog() */

   /* read user's data file, take indicated action. */
   printf("\n\nLogging in...\n");
   bool = 0;
   for(;;) {
      /* read line of input from user's file */
      if (!fill_buf()) {
	 if (!bool)
	    printf("\n\aWarning: no data found in file %s\n",filename);
	 printf("\nLogin finished!\n\n");
	 fclose(fp);
	 exit(0);
	 }
      bool = 1; 		/* indicate that at least one read was successful */
      switch (*buf) {		/* first char in buffer triggers appropriate function */
	case 'A' : autolog(user,pswrd);
		   break;
	case 'L' : login(user,pswrd);
		   break;
	case 'W' : waitfor(user,pswrd);
		   break;
	case 'U' : use();
		   break;
	case ';' : break;	 /* ignore comment lines in data file */

	default  : printf("\n\aError: invalid command statment ->%s<-\n",buf);
		   break;
	}
      }
}

/***************************************************************************
*  CheckForLAN() - Check for the presence of the LANtastic redirector.
*
*  Called by:	main()
*
*  Calls:	nothing
*
*  Returns:	1 if LANtastic is detected
*		0 if LAN is not present
*/
int CheckForLAN()
{
    /* set up registers and do interrupt (int 2fh, funct. B800h) */
    memset(&rg, '\0', sizeof(rg));
    rg.x.ax=0xb800;
    int86(0x2f,&rg,&rg);
    if (rg.h.al)
	return(1);	  /* if AL non-zero => LAN is there */
    return(0);

}


/****************************************************************************
*****************************************************************************
*  Login to a server functions section:
*  Functions defined:
*      autolog() -  Turns the LANtastic Autologin feature on or off.
*      login() -    login with or without specified adapter number.
*      waitfor() -  login waiting for server if there is no initial response.
*      TryLogin() - actual function that does tries to log you in.
*      DoLogin() -  function that sets up registers and does DOS interrupt.
*      ParseLoginLine() -
*		    scans the current line of the data file for correct input.
*      ESC_hit() -  Used in waitfor function, checks to see if user hits ESC.
*      delay() -    puts program in busy-wait loop for a given number of secs.
*/

/***************************************************************************
* autolog() - Turn the LANtastic Auto-login feature on or off
*
*   Called by:	main()
*
*   Calls:	nothing
*
*   Returns:	1 if AUTO statment is not formatted correctly
*/
autolog(user,password)
char *user, *password;
{
    char OnOrOff[17];	       /* a place to scan in the on or off command */
    char NameAndPassword[36]; /* buffer to put username and password in	 */
    int pos;		       /* index to keep track of a string position */

    /* make sure the AUTO statement is formatted correctly */
    if (sscanf(buf, "AUTO %s%s", OnOrOff, garb) != 1) {
	 printf("\n\aWarning: Badly formatted AUTO statement ->%s<-", buf);
	 return(1);
	 }

    /* clear out the buffer for the name and password.	Note that this will
       also automatically set us up for disabling auto-login as the "string"
       needed for the interrupt in that case is "<0><0>".		  */

       memset(NameAndPassword, '\0', sizeof(NameAndPassword));

    /* make sure the either the string 'ON' or 'OFF' was on the AUTO line */
    if (strcmp(OnOrOff, "ON") == 0) {
	strcpy(NameAndPassword, user);	    /* if auto-login is being turned */
	pos = strlen(NameAndPassword);	    /*	on, then parse the buffer    */
	NameAndPassword[pos]='*';	    /*	needed for the interrupt.    */
	strcat(NameAndPassword, password);  /*	it looks like:		     */
	NameAndPassword[pos]='\0';	    /*	"username<0>password<0>"     */
	/* alert the user that auto-login is being turned on */
	printf("\nLANtastic Auto-login enabled with username %s",user);
	}
    /* if it wasn't 'ON' make sure it is 'OFF' or we have a bad statement */
    else if (strcmp(OnOrOff, "OFF") != 0) {
	printf("\n\aWarning: Badly formatted AUTO statement ->%s<-", buf);
	return(1);
	}
    else printf("\nLANtastic Auto-login feature disabled");

    /* set up registers and do interrupt (int 21h, funct. 5FB6h) */
    rg.x.ax=0x5fb6;
    rg.x.di=(unsigned int)NameAndPassword;
    rg.h.bl=0xff;
    segread(&sg);
    sg.es=sg.ds;
    intdosx(&rg,&rg,&sg);

}


/***************************************************************************
* login() - Make one attempt to log into a server
*
*   Called by:	main()
*
*   Calls:	ParseLoginLine(), TryLogin()
*
*   Returns:	1 if login fails or LOGIN statement was badly formatted
*		0 if successful
*/
login(user,pswrd)
char *user, *pswrd;
{
char loginString[52];
int  ad_no;

   ad_no=MAX_ADAPTERS;	   /* initialize adapter number */

   /* Parse the login line from the data file, return error if parse fails */
   if (ParseLoginLine(loginString,server,user,pswrd,&ad_no) == 1)
      return (1);

   if (TryLogin(loginString,ad_no))
      return(1);

   return(0);
}


/***************************************************************************
* waitfor() - Attempt to login to a server until successful or user cancels
*	      retrys.
*
*   Called by:	main()
*
*   Calls:	ParseLoginLine(), TryLogin(), ESC_hit, DoDelay().
*
*   Returns:	1 for any error condition
*		0 if successful
*/
waitfor(user,pswrd)
char *user, *pswrd;
{
char loginString[52];
int  ad_no;

   ad_no=MAX_ADAPTERS;	   /* initialize adapter number */
   WaitFlag = 1;	   /* indicate login wait mode	*/

   /* Parse the login line from the data file, return error if parse fails */
   if (ParseLoginLine(loginString,server,user,pswrd,&ad_no) == 1)
      return (1);

   if (TryLogin(loginString,ad_no) != 0) {  /* try login & return if it works */

       /* give user the cancel message */
       printf("\nTrying to login to server %-s. Press ESC to cancel retrys...", server);

       while (TryLogin(loginString,ad_no))   /* keep trying to log in until:   */
	 if (ESC_hit()) {		     /* ESC is hit or login succeeds	*/
	    printf("\nLogin retrys to server %-s cancelled.",server);
	    return(1);			     /* return failure			*/
	    }
	 else
	    DoDelay(PAUSE_LENGTH);   /* delay PAUSE_LENGTH seconds and try again */
       }

   WaitFlag = 0;		    /* clear the wait flag */
   return(0);			    /* return success */
}


/****************************************************************************
*  ParseLoginLine: scan the current login line for correct format and
*  information.  Returns error if either is incorrect.
*
*   Called by:	login(), waitfor().
*
*   Calls:	nothing
*
*   Returns:	1 for any error condition
*		0 if successful
*
*/
ParseLoginLine(loginString,server,user,pswrd,ad_no)
char *loginString, *server, *user, *pswrd;
int *ad_no;
{

int pos, pos1;

   /* scan for server name and specified adapter number, if present */
   if (*buf == 'L') {
      if (sscanf(buf, "LOGIN %s%s", server, garb) != 1)
      if (sscanf(buf, "LOGIN %s%d", server, ad_no) != 2) {
	printf("\n\aWarning: Badly formatted LOGIN statement ->%s<-", buf);
	    return(1);
	    }
      }
   else {
      if (sscanf(buf, "WAITFOR %s%s", server, garb) !=1)
	 if (sscanf(buf, "WAITFOR %s%d", server, ad_no) != 2) {
	 printf("\n\aWarning: Badly formatted WAITFOR statement ->%s<-", buf);
	 return(1);
	 }
      }

   /* check for valid adapter number.  MAX_ADAPTERS indicates none specified */
   if (*ad_no < 0 || *ad_no > MAX_ADAPTERS) {
	  printf("\n\aWarning: Invalid adapter number specified ->%s<-",buf);
	  return(1);
	  }

   /* set up login string. it looks like: "\\server\user<0>password<0>" */
   strcpy(loginString,"\\\\");
   strcat(loginString,server);
   strcat(loginString,"\\");
   strcat(loginString,user);
   pos=strlen(loginString);
   loginString[pos]='*';
   loginString[pos+1]='\0';
   strcat(loginString,pswrd);
   pos1=strlen(loginString);
   loginString[pos]=0;
   loginString[pos1+1]=0;
   return(0);
 }


/****************************************************************************
*   TryLogin(loginString, ad_no)
*   Using the loginString and adapter number (ad_no), attempt a login.
*    If the adapter number is not specified, attempt login on all adapters.
*
*   Called by:	login(), waitfor().
*
*   Calls:	DoLogin(), geterr().
*
*   Returns:	1 if login fails
*		0 if login works
*
*/
TryLogin(loginString,ad_no)
char *loginString;
int  ad_no;
{
int i;

   i=ad_no;		/* set i to adapter number for use in 'logged in' message */

   /* if ad_no == MAX_ADAPTERS => no ad. no. specified, try login on all possible adapters */
   if (ad_no == MAX_ADAPTERS)
      for (i=0; i < MAX_ADAPTERS; i++) {
	 DoLogin(loginString,i);
	 if (rg.x.cflag && rg.x.ax == 0x35)    /* break if error is other than	*/
		;			       /* "Cannot locate network name" */
	 else
		break;
	 }
   else DoLogin(loginString,ad_no);

   if (!rg.x.cflag)
      printf("\nLogged into: %-s on adapter %d",server,i);
   else {
      if (WaitFlag)
	 return(1);
      get_err();
      printf("\nError logging into %-s -> %s",server,err);
      return(1);
      }

   return(0);
}


/***************************************************************************
*   DoLogin(LoginString,ad_no)
*
*   Set up the registers and do the dos interrupt to login to a server using
*    the provided login string and adapter number.
*
*   Called by:	TryLogin().
*
*   Calls:	nothing
*
*   returns:	nothing, but modifies the global register and segment variables
*
*/
DoLogin(LoginString,ad_no)
char *LoginString;
int ad_no;
{
   rg.x.ax=0x5f81;
   rg.x.di=(unsigned int)LoginString;
   rg.h.bl=ad_no;
   segread(&sg);
   sg.es=sg.ds;
   intdosx(&rg,&rg,&sg);

}


/****************************************************************************
*   ESC_hit() - check to see if the user has hit the ESC key.
*
*   Called by:	waitfor()
*
*   Calls:	nothing
*
*   Returns:	1 if ESC was pressed
*		0 if not
*
*/
ESC_hit()
{

   /* see if the user has hit the ESC key to cancel wait */
   if (_kbhit())
      if (_getch() == ESC_CHAR)
	return(1);

   return(0);

}

/****************************************************************************
* DoDelay(DelayLen) - delay for the amount of time specified by DelayLen.
*
*   Called by:	waitfor().
*
*   Calls:	nothing
*
*   Returns:	nothing
*
*/
DoDelay(DelayLen)
int DelayLen;
{
   time_t CurrentTime, EndTime;

   time(&CurrentTime);			/* get the current time     */
   EndTime = CurrentTime + DelayLen;	/* calculate the ending time */
   while (CurrentTime < EndTime)	/* keep checking the time   */
      time(&CurrentTime);		/*  until we're there       */

}

/***************************************************************************
****************************************************************************
*  Use drives and printers section
*  Functions defined:
*	use() -     Attempt to redirect the drive or printer specified
*
****************************************************************************/

/****************************************************************************
* use() - Attempt to redirect a device
*
*   Called by:	main()
*
*   Calls:	geterr()
*
*   Returns:	1 if login fails or LOGIN string is badly formatted
*		0 if successful
*
*/
use()
{
char locname[17], netname[129];
int type;

   /* get local device to redirect and network device name */
   if (sscanf(buf, "USE %s%s%s", locname, netname, garb) != 2) {
      printf("\n\aWarning: Badly fomatted USE statement ->%s<-", buf);
      return(1);
      }

   /* decide type of use, set up registers, do interrupt */
   if (strncmp(locname, "PRN", 3) == 0 || strncmp(locname, "LPT", 3) == 0 || strncmp(locname,"COM", 3) == 0)
      type = PRINTER;
   else
      type = DRIVE;

   rg.x.ax=0x5f03;
   rg.h.bl=type;
   rg.x.cx=0;
   rg.x.si=(unsigned int)locname;
   rg.x.di=(unsigned int)netname;
   segread(&sg);
   sg.es=sg.ds;
   intdosx(&rg,&rg,&sg);

   /* if carry flag set == error, give message  */
   if (!rg.x.cflag)
      printf("\nDevice %-s redirected to %-s ",locname, netname);
   else {
      get_err();
      printf("\nError redirecting %-s -> %s",locname,err);
      return(1);
      }

   return(0);

}

/***************************************************************************
****************************************************************************
*
*   Utilities section - various general functions used by any other function
*
*   Contains:	geterr(), towupper(), fillbuf().
*
****************************************************************************/

/* get_err() - Expand LANOS error code to string */
get_err()
{
   /* set up the registers */
   rg.x.bx = rg.x.ax;
   rg.h.al = (unsigned char)rg.x.ax;
   rg.h.ah = 5;                         /* 5 = LANOS funct # to expand error number */
   segread(&sg);
   sg.es=sg.ds;
   int86x(0x2f,&rg,&rg,&sg);

   /* ES:DI now points to a read only string containing expanded error message */
   FP_SEG(error) = sg.es;
   FP_OFF(error) = rg.x.di;
   eptr = error;
   bptr = err;
   do {                 /* read system string to local buffer */
      *bptr = *eptr;
      ++bptr;
      ++eptr;
      } while (*eptr != '\0');
   *bptr = '\0';
}


/* convert entire word to uppercase  */
towupper(wrd)
char *wrd;
{
   do {
   *wrd = toupper(*wrd);
   ++wrd;
      } while (*wrd != '\0');

}


/* fill_buf - read a line from user's data file into global BUF
      returns: 0 - if EOF encountered
	       1 - if buffer was filled				*/
int fill_buf()
{
   int ch, pos;

   /* initialize buffer */
   for (pos = 0; pos <= sizeof(buf); pos++)
      buf[pos] = '\0';

   /* skip white space */
   do {
      ch = fgetc(fp);
      } while (isspace(ch));
   if (ch == EOF)
	 return 0;

   pos = 0;
   while (ch != '\n' && ch != EOF) {
      buf[pos++] = ch;
      ch = fgetc(fp);
      }
   towupper(buf);
   return 1;
}
